//==============================================================================
// A stereo, easier to use, takes less filesize, and more customizable than 90's.
//==============================================================================
class CustomStereo extends MSStereo;

var() music Songs[10];
var() float Lengths[10];

var StereoButtonSong MyButtons[10];
var() vector ButtonPlaces[10];

var int CurrentSong;
var DeusExPlayer TrueOwner;

function PostBeginPlay()
{
 local int i;
 
 for(i=0; i<10; i++)
 {
  MyButtons[i] = Spawn(class'StereoButtonSong' ,Self,,Location + (ButtonPlaces[i] >> Rotation),Rotation);
  MyButtons[i].Stereo = Self;
  MyButtons[i].SetPropertyText("ButtonNum", string(i + 1));
 }

 Super.BeginPlay();
}

function SetLength(float NewLength, int i)
{
 Lengths[i] = NewLength;
}

function SetSong(Music NewSong, int i)
{
 Songs[i] = NewSong;
}

function Frob(actor Frobber, Inventory frobWith)
{
	local DeusExPlayer player;

	Super.Frob(Frobber, frobWith);
	
	player = DeusExPlayer(Frobber);

	if (player != None)
	{
		player.ClientMessage("|p4Press a button to start a song, songs will play in a list; customize your songs using your |p3House Keeper Gun.");
	}
}

function SongButtonPushed(int i, DeusExPlayer Listener)
{
 local string SongName;
 
 if (Listener != TrueOwner) return;
 
 Song = Songs[i];
 
 SongName = String(Song);
 
 if (SongName ~= "None") SongName = "Nothing";
 if (Songs[i] == None) SongName = "Nothing";
 
                Song = Music( DynamicLoadObject( ""$Song$"", class'Music' ) );
		Listener.ClientSetMusic( Song, 0, 255, MTRAN_Fade );
                Listener.ClientMessage("|p3You are now listening to "$SongName$"!");
 
 CurrentSong = i - 1;
 
 SetTimer(Lengths[i - 1] + 0.2, False);
}

function Timer()
{
 if (TrueOwner == None) return;
 
 CurrentSong++;
 
 if (CurrentSong > 9 || Songs[CurrentSong] == None) CurrentSong = 0;
 
 SongButtonPushed(CurrentSong, TrueOWner);
}

defaultproperties
{
     bCanBeBase=True
     ItemName="Custom Stereo"
     Mesh=LodMesh'DeusExDeco.VendingMachine'
     CollisionRadius=34.000000
     CollisionHeight=50.000000
     Skin=Texture'MSStereo.Skins.MSStereoSkin'
     Mass=150.000000
     Buoyancy=100.000000
     NumSongs=1
     ButtonPlaces2(0)=(X=19.75,Y=20.5,Z=7.8)
     ButtonPlaces2(1)=(X=19.75,Y=20.5,Z=2.3)
     ButtonPlaces2(2)=(X=19.75,Y=20.5,Z=-3.2)
     ButtonPlaces2(3)=(X=19.75,Y=20.5,Z=-8.7)
     ButtonPlaces2(4)=(X=19.75,Y=20.5,Z=-14.2)
     ButtonPlaces(0)=(X=19.75,Y=-20.5,Z=7.8)
     ButtonPlaces(1)=(X=19.75,Y=-20.5,Z=2.3)
     ButtonPlaces(2)=(X=19.75,Y=-20.5,Z=-3.2)
     ButtonPlaces(3)=(X=19.75,Y=-20.5,Z=-8.7)
     ButtonPlaces(4)=(X=19.75,Y=-20.5,Z=-14.2)
     ButtonPlaces(5)=(X=19.75,Y=-20.5,Z=-19.7)
     ButtonPlaces(6)=(X=19.75,Y=-20.5,Z=-25.2)
     ButtonPlaces(7)=(X=19.75,Y=-20.5,Z=-30.7)
     ButtonPlaces(8)=(X=19.75,Y=-20.5,Z=-36.2)
     ButtonPlaces(9)=(X=19.75,Y=-20.5,Z=-41.7)
}
